<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\Services;

use Flowaxy\Domain\Content\ValueObjects\ContentId;

// Служба оновлення поста
class UpdatePostService
{
    public function __construct(
        private readonly ContentRepositoryInterface $repository,
    ) {
    }

    public function execute(int $id, array $data): bool
    {
        return $this->repository->update(new ContentId($id), $data);
    }
}
