<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\Services;

use Flowaxy\Domain\Content\ValueObjects\ContentId;

// Служба видалення поста
class DeletePostService
{
    public function __construct(
        private readonly ContentRepositoryInterface $repository,
    ) {
    }

    public function execute(int $id): bool
    {
        return $this->repository->delete(new ContentId($id));
    }
}
