<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\Services;

use Flowaxy\Domain\Content\DTOs\CreatePostDTO;

// Служба створення поста
class CreatePostService
{
    public function __construct(
        private readonly ContentRepositoryInterface $repository,
    ) {
    }

    public function execute(CreatePostDTO $dto): int
    {
        $post = $this->repository->create($dto->toArray());
        return $post->getId()->getValue();
    }
}
