<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\Services;

use Flowaxy\Domain\Content\Entities\Post;
use Flowaxy\Domain\Content\ValueObjects\ContentId;

// Служба роботи з контентом
class ContentService
{
    public function __construct(
        private readonly ContentRepositoryInterface $repository,
    ) {
    }

    public function getPost(ContentId $id): ?Post
    {
        return $this->repository->findById($id);
    }

    public function createPost(array $data): Post
    {
        return $this->repository->create($data);
    }

    public function updatePost(ContentId $id, array $data): bool
    {
        return $this->repository->update($id, $data);
    }

    public function deletePost(ContentId $id): bool
    {
        return $this->repository->delete($id);
    }
}
