<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\Entities;

use Flowaxy\Domain\Content\ValueObjects\ContentId;
use Flowaxy\Domain\Content\ValueObjects\ContentStatus;

// Сущність сторінки
class Page
{
    public function __construct(
        private readonly ContentId $id,
        private string $title,
        private string $content,
        private ContentStatus $status,
        private ?string $slug = null,
    ) {
    }

    public function getId(): ContentId
    {
        return $this->id;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function setContent(string $content): void
    {
        $this->content = $content;
    }

    public function getStatus(): ContentStatus
    {
        return $this->status;
    }

    public function setStatus(ContentStatus $status): void
    {
        $this->status = $status;
    }

    public function getSlug(): ?string
    {
        return $this->slug;
    }

    public function setSlug(?string $slug): void
    {
        $this->slug = $slug;
    }
}
