<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\Entities;

use Flowaxy\Domain\Content\ValueObjects\ContentId;

// Сущність медіа файлу
class Media
{
    public function __construct(
        private readonly ContentId $id,
        private string $filename,
        private string $mimeType,
        private int $size,
        private string $path,
        private ?string $alt = null,
    ) {
    }

    public function getId(): ContentId
    {
        return $this->id;
    }

    public function getFilename(): string
    {
        return $this->filename;
    }

    public function getMimeType(): string
    {
        return $this->mimeType;
    }

    public function getSize(): int
    {
        return $this->size;
    }

    public function getPath(): string
    {
        return $this->path;
    }

    public function getAlt(): ?string
    {
        return $this->alt;
    }

    public function setAlt(?string $alt): void
    {
        $this->alt = $alt;
    }
}
