<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\DTOs;

// DTO для поста
class PostDTO
{
    public function __construct(
        public readonly ?int $id,
        public readonly string $title,
        public readonly string $content,
        public readonly string $status,
        public readonly ?string $slug = null,
        public readonly ?int $authorId = null,
        public readonly ?string $createdAt = null,
        public readonly ?string $updatedAt = null,
    ) {
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'content' => $this->content,
            'status' => $this->status,
            'slug' => $this->slug,
            'author_id' => $this->authorId,
            'created_at' => $this->createdAt,
            'updated_at' => $this->updatedAt,
        ];
    }
}
