<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\DTOs;

// DTO для створення поста
class CreatePostDTO
{
    public function __construct(
        public readonly string $title,
        public readonly string $content,
        public readonly string $status = 'draft',
        public readonly ?string $slug = null,
        public readonly ?int $authorId = null,
    ) {
    }

    public function toArray(): array
    {
        return [
            'title' => $this->title,
            'content' => $this->content,
            'status' => $this->status,
            'slug' => $this->slug,
            'author_id' => $this->authorId,
        ];
    }
}
