<?php

/**
 * Виконавець планових завдань
 *
 * @package Flowaxy\Core\System\Tasks
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Tasks;

final class TaskRunner
{
    /**
     * @var array<string, ScheduledTask>
     */
    private array $tasks = [];

    /**
     * Додавання завдання
     *
     * @param ScheduledTask $task Завдання
     * @return void
     */
    public function add(ScheduledTask $task): void
    {
        $this->tasks[$task->getName()] = $task;
    }

    /**
     * Виконання всіх готових завдань
     *
     * @return void
     */
    public function run(): void
    {
        foreach ($this->tasks as $task) {
            if ($task->isDue()) {
                $task->run();
            }
        }
    }

    /**
     * Отримання всіх завдань
     *
     * @return array<string, ScheduledTask>
     */
    public function getTasks(): array
    {
        return $this->tasks;
    }
}
