<?php

declare(strict_types=1);

/**
 * Миграция для создания таблицы users
 *
 * @package Flowaxy\Core\System\Migrations
 */

/**
 * Создание таблицы users
 *
 * @param PDO $db
 * @return bool
 */
function migration_create_users_table(PDO $db): bool
{
    try {
        $sql = "CREATE TABLE IF NOT EXISTS `users` (
            `id` int unsigned NOT NULL AUTO_INCREMENT,
            `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
            `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
            `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `role_ids` json DEFAULT NULL COMMENT 'Массив ID ролей пользователя',
            `session_token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Токен сессии для защиты от одновременного входа',
            `last_activity` datetime DEFAULT NULL COMMENT 'Время последней активности пользователя',
            `is_active` tinyint(1) DEFAULT '1' COMMENT 'Статус активности пользователя (1 - активен, 0 - неактивен)',
            `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `username` (`username`),
            KEY `idx_email` (`email`),
            KEY `idx_session_token` (`session_token`),
            KEY `idx_last_activity` (`last_activity`),
            KEY `idx_is_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

        $db->exec($sql);

        return true;
    } catch (\Throwable $e) {
        if (class_exists(\Flowaxy\Support\Facades\Log::class)) {
            try {
                \Flowaxy\Support\Facades\Log::Error('Ошибка создания таблицы users', [
                    'exception' => $e,
                ]);
            } catch (\Throwable $logError) {
                // Ignore logging errors
            }
        }
        return false;
    }
}
