<?php

declare(strict_types=1);

/**
 * Миграция для создания таблицы permissions
 *
 * @package Flowaxy\Core\System\Migrations
 */

/**
 * Создание таблицы permissions
 *
 * @param PDO $db
 * @return bool
 */
function migration_create_permissions_table(PDO $db): bool
{
    try {
        $sql = "CREATE TABLE IF NOT EXISTS `permissions` (
            `id` int unsigned NOT NULL AUTO_INCREMENT,
            `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
            `slug` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
            `description` text COLLATE utf8mb4_unicode_ci,
            `category` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Категория разрешения (admin, cabinet, plugin, etc.)',
            `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `slug` (`slug`),
            KEY `category` (`category`),
            KEY `name` (`name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

        $db->exec($sql);

        return true;
    } catch (\Throwable $e) {
        if (class_exists(\Flowaxy\Support\Facades\Log::class)) {
            try {
                \Flowaxy\Support\Facades\Log::Error('Ошибка создания таблицы permissions', [
                    'exception' => $e,
                ]);
            } catch (\Throwable $logError) {
                // Ignore logging errors
            }
        }
        return false;
    }
}
