<?php

declare(strict_types=1);

namespace Flowaxy\Core\System;

/**
 * Базовый класс для миграций
 *
 * @package Flowaxy\Core\System
 */
abstract class Migration
{
    /**
     * Применить миграцию
     *
     * @return bool
     */
    abstract public function up(): bool;

    /**
     * Откатить миграцию
     *
     * @return bool
     */
    abstract public function down(): bool;

    /**
     * Получить имя миграции
     *
     * @return string
     */
    public function getName(): string
    {
        $className = static::class;
        $parts = explode('\\', $className);
        return end($parts);
    }
}
