<?php

/**
 * Сторінка помилки: потрібна установка системи
 * Відображається, коли база даних не налаштована
 */

// Завантажуємо PathResolver, якщо він ще не завантажений
if (!\class_exists('Flowaxy\Core\System\PathResolver')) {
    $rootDir = \dirname(__DIR__, 5); // flowaxy/Core/System/Errors/Templates -> workbench/
    $pathResolverFile = $rootDir . DS . 'flowaxy' . DS . 'Core' . DS . 'System' . DS . 'PathResolver.php';
    if (\file_exists($pathResolverFile)) {
        require_once $pathResolverFile;
    }
}

use Flowaxy\Core\System\PathResolver;

// Перевіряємо наявність директорії install
$installDir = PathResolver::root() . DS . 'install';
$installDirExists = \is_dir($installDir);

$httpCode = 503;
$errorCode = '503';
$errorTitle = 'Потрібна установка системи';
$errorMessage = $installDirExists
    ? 'Для початку роботи необхідно встановити Flowaxy CMS. Натисніть кнопку нижче, щоб запустити майстер установки та налаштувати систему.'
    : 'Для встановлення Flowaxy CMS спочатку завантажте установщик з GitHub. Натисніть кнопку вище для завантаження, розпакуйте архів у корінь проекту, після чого оновіть цю сторінку для продовження.';
$title = 'Потрібна установка системи';
$debugInfo = null; // Для installation-required не показуємо debug інформацію

// Дії (кнопки) - відображаються в header
$actions = [];

// Кнопка в header - завжди веде на GitHub, але активна тільки якщо install немає
$actions[] = [
    'text' => 'Завантажити установщик',
    'href' => 'https://github.com/flowaxy/install',
    'target' => '_blank',
    'rel' => 'noopener noreferrer',
    'type' => 'primary',
    'icon' => 'fa-solid fa-download',
    'disabled' => $installDirExists, // Якщо install існує - кнопка неактивна
];

// Кнопка після тексту
$buttonAfterText = null;
if ($installDirExists) {
    // Якщо директорія install існує - показуємо кнопку встановлення
    $buttonAfterText = [
        'text' => 'Встановити',
        'href' => '/install',
        'type' => 'primary',
    ];
}

// Використовуємо основний шаблон помилок
require __DIR__ . DS . 'error.php';
