<?php

/**
 * Service Provider для модуля Errors
 *
 * @package Flowaxy\Core\System\Errors
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Errors;

use Flowaxy\Core\Contracts\ContainerInterface;
use Flowaxy\Core\System\Base\ModuleServiceProvider;
use Flowaxy\Core\System\Errors\Services\ErrorHandler;
use Flowaxy\Core\System\Errors\Services\ErrorRenderer;
use Flowaxy\Core\System\Errors\Services\ErrorMessages;
use Flowaxy\Core\System\Errors\Services\InstallationService;

class ErrorServiceProvider extends ModuleServiceProvider
{
    /**
     * Реєстрація біндів/одиночок в контейнері
     */
    public function register(ContainerInterface $container): void
    {
        // Реєстрація ErrorModule як singleton
        $container->singleton(ErrorModule::class, function () {
            return ErrorModule::getInstance();
        });

        // Реєстрація сервісів
        $container->singleton(ErrorHandler::class, function () {
            return new ErrorHandler();
        });

        $container->singleton(ErrorRenderer::class, function () {
            return new ErrorRenderer();
        });

        $container->singleton(ErrorMessages::class, function () {
            return new ErrorMessages();
        });

        $container->singleton(InstallationService::class, function () {
            return new InstallationService();
        });
    }

    /**
     * Опціональна ініціалізація після реєстрації
     */
    public function boot(ContainerInterface $container): void
    {
        // Ініціалізація модуля після реєстрації
    }
}
