<?php

/**
 * Вспомогательный класс для загрузки модуля Errors
 *
 * @package Flowaxy\Core\System\Errors
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Errors;

use Flowaxy\Core\System\PathResolver;
use Throwable;

use function class_exists;
use function file_exists;
use const DS;

final class ErrorModuleLoader
{
    /**
     * Загрузка модуля Errors и его зависимостей
     *
     * @return ErrorModule|null Экземпляр модуля или null если не удалось загрузить
     */
    public static function load(): ?ErrorModule
    {
        try {
            // Завантажуємо ModuleInterface та BaseModule спочатку
            $moduleInterfaceFile = PathResolver::flowaxy() . DS . 'Core' . DS . 'System' . DS . 'Base' . DS . 'ModuleInterface.php';
            if (file_exists($moduleInterfaceFile)) {
                require_once $moduleInterfaceFile;
            }

            $baseModuleFile = PathResolver::flowaxy() . DS . 'Core' . DS . 'System' . DS . 'Base' . DS . 'BaseModule.php';
            if (file_exists($baseModuleFile)) {
                require_once $baseModuleFile;
            }

            $errorModuleFile = PathResolver::flowaxy() . DS . 'Core' . DS . 'System' . DS . 'Errors' . DS . 'ErrorModule.php';
            if (!file_exists($errorModuleFile)) {
                return null;
            }

            require_once $errorModuleFile;

            // Завантажуємо залежності ErrorModule
            $errorRendererFile = PathResolver::flowaxy() . DS . 'Core' . DS . 'System' . DS . 'Errors' . DS . 'Services' . DS . 'ErrorRenderer.php';
            if (file_exists($errorRendererFile)) {
                require_once $errorRendererFile;
            }

            $errorMessagesFile = PathResolver::flowaxy() . DS . 'Core' . DS . 'System' . DS . 'Errors' . DS . 'Services' . DS . 'ErrorMessages.php';
            if (file_exists($errorMessagesFile)) {
                require_once $errorMessagesFile;
            }

            $errorHandlerFile = PathResolver::flowaxy() . DS . 'Core' . DS . 'System' . DS . 'Errors' . DS . 'Services' . DS . 'ErrorHandler.php';
            if (file_exists($errorHandlerFile)) {
                require_once $errorHandlerFile;
            }

            if (class_exists(ErrorModule::class)) {
                return ErrorModule::getInstance();
            }
        } catch (Throwable $e) {
            // Модуль Errors недоступен
            return null;
        }

        return null;
    }
}
