<?php

/**
 * Модуль обробки помилок
 *
 * @package Flowaxy\Core\System\Errors
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Errors;

use Flowaxy\Core\System\Base\BaseModule;
use Flowaxy\Core\System\Errors\Services\ErrorHandler;
use Flowaxy\Core\System\Errors\Services\ErrorMessages;
use Flowaxy\Core\System\Errors\Services\ErrorRenderer;
use Flowaxy\Core\System\Errors\Services\InstallationService;

use function class_exists;
use function dirname;
use function file_exists;
use const DS;

final class ErrorModule extends BaseModule
{
    private ?ErrorHandler $handler = null;
    private ?InstallationService $installationService = null;

    /**
     * Ініціалізація модуля
     */
    protected function init(): void
    {
        // Ініціалізація модуля обробки помилок
    }

    /**
     * Реєстрація хуків модуля
     */
    public function registerHooks(): void
    {
        // Реєстрація хуків обробки помилок
    }

    /**
     * Отримання обробника помилок
     *
     * @return ErrorHandler
     */
    public function getHandler(): ErrorHandler
    {
        if ($this->handler === null) {
            // Переконаємося, що всі залежності завантажені
            if (!class_exists(ErrorRenderer::class)) {
                $errorRendererFile = dirname(__DIR__) . DS . 'Errors' . DS . 'Services' . DS . 'ErrorRenderer.php';
                if (file_exists($errorRendererFile)) {
                    require_once $errorRendererFile;
                }
            }
            if (!class_exists(ErrorMessages::class)) {
                $errorMessagesFile = dirname(__DIR__) . DS . 'Errors' . DS . 'Services' . DS . 'ErrorMessages.php';
                if (file_exists($errorMessagesFile)) {
                    require_once $errorMessagesFile;
                }
            }
            $this->handler = new ErrorHandler();
        }

        return $this->handler;
    }

    /**
     * Отримання сервісу встановлення
     *
     * @return InstallationService
     */
    public function getInstallationService(): InstallationService
    {
        if ($this->installationService === null) {
            // Переконаємося, що всі залежності завантажені
            if (!class_exists(ErrorRenderer::class)) {
                $errorRendererFile = dirname(__DIR__) . DS . 'Errors' . DS . 'Services' . DS . 'ErrorRenderer.php';
                if (file_exists($errorRendererFile)) {
                    require_once $errorRendererFile;
                }
            }
            $this->installationService = new InstallationService();
        }

        return $this->installationService;
    }


    /**
     * Отримання інформації про модуль
     *
     * @return array<string, mixed>
     */
    public function getInfo(): array
    {
        return [
            'name' => 'Errors Module',
            'version' => '1.0.0',
            'description' => 'Модуль обробки помилок та критичних ситуацій',
        ];
    }
}
