<?php

/**
 * Завантажувач конфігураційних файлів
 *
 * @package Flowaxy\Core\System\Environment
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Environment;

use Flowaxy\Support\Facades\Log;

class ConfigLoader
{
    /**
     * Завантаження конфігураційного файлу
     *
     * @param string $filePath Шлях до файлу
     * @return array<string, mixed>
     */
    public function load(string $filePath): array
    {
        if (!file_exists($filePath) || !is_readable($filePath)) {
            return [];
        }

        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));

        try {
            if ($extension === 'php') {
                return require $filePath;
            } elseif ($extension === 'json') {
                $content = file_get_contents($filePath);
                if ($content === false) {
                    return [];
                }
                $decoded = json_decode($content, true);
                return is_array($decoded) ? $decoded : [];
            } elseif ($extension === 'ini') {
                $parsed = parse_ini_file($filePath, true);
                return is_array($parsed) ? $parsed : [];
            }
        } catch (\Exception $e) {
            Log::Error("ConfigLoader: помилка завантаження {$filePath}: " . $e->getMessage(), [
                'exception' => $e,
                'file' => $filePath
            ]);
        }

        return [];
    }
}
