<?php

/**
 * Базовий сервіс-провайдер.
 *
 * @package Flowaxy\Core\System\Container
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Container;

use Flowaxy\Core\Contracts\ServiceProviderInterface;
use Flowaxy\Core\Contracts\ContainerInterface;

abstract class ServiceProvider implements ServiceProviderInterface
{
    protected ContainerInterface $container;

    final public function register(ContainerInterface $container): void
    {
        $this->container = $container;
        $this->registerBindings();
    }

    public function boot(ContainerInterface $container): void
    {
        // За замовчуванням нічого не робимо
    }

    /**
     * Метод для реєстрації біндів у нащадках.
     */
    abstract protected function registerBindings(): void;
}
