<?php

/**
 * Service Provider для тем та плагінів
 *
 * @package Flowaxy\Core\System\Container\Providers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Container\Providers;

use Flowaxy\Core\System\Container\ServiceProvider;
use Flowaxy\Domain\Theme\Services\ThemeRepositoryInterface;
use Flowaxy\Domain\Theme\Services\ThemeSettingsRepositoryInterface;
use Flowaxy\Domain\Plugin\Services\PluginRepositoryInterface;
use Flowaxy\Domain\Plugin\Services\PluginFilesystemInterface;
use Flowaxy\Domain\Plugin\Services\PluginCacheInterface;
use Flowaxy\Infrastructure\Persistence\Repositories\ThemeRepository;
use Flowaxy\Infrastructure\Persistence\Repositories\ThemeSettingsRepository;
use Flowaxy\Infrastructure\Persistence\Repositories\PluginRepository;
use Flowaxy\Infrastructure\Filesystem\PluginFilesystem;
use Flowaxy\Infrastructure\Cache\PluginCacheManager;
use Flowaxy\Domain\Theme\Services\ActivateThemeService;
use Flowaxy\Domain\Theme\Services\UpdateThemeSettingsService;
use Flowaxy\Domain\Plugin\Services\InstallPluginService;
use Flowaxy\Domain\Plugin\Services\ActivatePluginService;
use Flowaxy\Domain\Plugin\Services\DeactivatePluginService;
use Flowaxy\Domain\Plugin\Services\TogglePluginService;
use Flowaxy\Domain\Plugin\Services\UninstallPluginService;
use Flowaxy\Domain\Plugin\Services\ApplicationPluginLifecycleService;

final class ThemeServiceProvider extends ServiceProvider
{
    protected function registerBindings(): void
    {
        if (! $this->container->has(ThemeRepositoryInterface::class)) {
            $this->container->singleton(ThemeRepositoryInterface::class, static fn () => new ThemeRepository());
        }

        if (! $this->container->has(PluginRepositoryInterface::class)) {
            $this->container->singleton(PluginRepositoryInterface::class, static fn () => new PluginRepository());
        }

        if (! $this->container->has(ThemeSettingsRepositoryInterface::class)) {
            $this->container->singleton(ThemeSettingsRepositoryInterface::class, static fn () => new ThemeSettingsRepository());
        }

        // @phpstan-ignore-next-line - это регистрация сервиса, не системная команда system()
        if (! $this->container->has(PluginFilesystemInterface::class)) {
            $this->container->singleton(PluginFilesystemInterface::class, static fn () => new PluginFilesystem());
        }

        if (! $this->container->has(PluginCacheInterface::class)) {
            $this->container->singleton(PluginCacheInterface::class, static fn () => new PluginCacheManager());
        }

        if (! $this->container->has(ActivateThemeService::class)) {
            $this->container->singleton(ActivateThemeService::class, fn () => new ActivateThemeService(
                $this->container->make(ThemeRepositoryInterface::class)
            ));
        }

        if (! $this->container->has(UpdateThemeSettingsService::class)) {
            $this->container->singleton(UpdateThemeSettingsService::class, fn () => new UpdateThemeSettingsService(
                $this->container->make(ThemeSettingsRepositoryInterface::class),
                $this->container->make(ThemeRepositoryInterface::class)
            ));
        }

        if (! $this->container->has(InstallPluginService::class)) {
            $this->container->singleton(InstallPluginService::class, fn () => new InstallPluginService(
                $this->container->make(PluginRepositoryInterface::class)
            ));
        }

        if (! $this->container->has(ActivatePluginService::class)) {
            $this->container->singleton(ActivatePluginService::class, fn () => new ActivatePluginService(
                $this->container->make(PluginRepositoryInterface::class)
            ));
        }

        if (! $this->container->has(DeactivatePluginService::class)) {
            $this->container->singleton(DeactivatePluginService::class, fn () => new DeactivatePluginService(
                $this->container->make(PluginRepositoryInterface::class)
            ));
        }

        if (! $this->container->has(TogglePluginService::class)) {
            $this->container->singleton(TogglePluginService::class, fn () => new TogglePluginService(
                $this->container->make(ActivatePluginService::class),
                $this->container->make(DeactivatePluginService::class)
            ));
        }

        if (! $this->container->has(UninstallPluginService::class)) {
            $this->container->singleton(UninstallPluginService::class, fn () => new UninstallPluginService(
                $this->container->make(PluginRepositoryInterface::class)
            ));
        }

        if (! $this->container->has(ApplicationPluginLifecycleService::class)) {
            $this->container->singleton(ApplicationPluginLifecycleService::class, fn () => new ApplicationPluginLifecycleService(
                $this->container->make(PluginFilesystemInterface::class),
                $this->container->make(PluginCacheInterface::class),
                $this->container->make(InstallPluginService::class),
                $this->container->make(ActivatePluginService::class),
                $this->container->make(DeactivatePluginService::class),
                $this->container->make(UninstallPluginService::class)
            ));
        }
    }
}
