<?php

/**
 * Service Provider для модуля плагінів
 *
 * @package Flowaxy\Core\System\Container\Providers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Container\Providers;

use Flowaxy\Core\System\Container\ServiceProvider;
use Flowaxy\Core\Contracts\ServiceProviderInterface;
use Flowaxy\Core\Contracts\ContainerInterface;
use Flowaxy\Core\System\ModuleLoader;
use Flowaxy\Support\Managers\PluginManager;

final class PluginModuleServiceProvider extends ServiceProvider implements ServiceProviderInterface
{
    protected function registerBindings(): void
    {
        $this->container->singleton(PluginManager::class, static function () {
            $module = ModuleLoader::loadModule('PluginManager');

            return $module ?? PluginManager::getInstance();
        });
    }

    public function boot(ContainerInterface $container): void
    {
        $pluginManager = $container->make(PluginManager::class);
        if ($pluginManager instanceof PluginManager && method_exists($pluginManager, 'initializePlugins')) {
            $pluginManager->initializePlugins();
        }
    }
}
