<?php

/**
 * Базовий сервіс-провайдер для модулів
 *
 * @package Flowaxy\Core\System\Base
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Base;

use Flowaxy\Core\Contracts\ContainerInterface;
use Flowaxy\Core\Contracts\ServiceProviderInterface;

abstract class ModuleServiceProvider implements ServiceProviderInterface
{
    /**
     * Реєстрація біндів/одиночок в контейнері
     */
    public function register(ContainerInterface $container): void
    {
        // Перевизначається в дочірніх класах
    }

    /**
     * Опціональна ініціалізація після реєстрації
     */
    public function boot(ContainerInterface $container): void
    {
        // Перевизначається в дочірніх класах
    }
}
