<?php

/**
 * Інтерфейс модуля
 *
 * @package Flowaxy\Core\System\Base
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Base;

interface ModuleInterface
{
    /**
     * Реєстрація модуля (маршрути, хуки, сервіси)
     */
    public function register(): void;

    /**
     * Ініціалізація модуля після реєстрації
     */
    public function boot(): void;

    /**
     * Отримання інформації про модуль
     *
     * @return array<string, mixed>
     */
    public function getInfo(): array;
}
