<?php

/**
 * Guard для сессионной аутентификации
 *
 * @package Flowaxy\Core\System\Auth\Guards
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Core\System\Auth\Guards;

use Flowaxy\Contracts\Security\GuardInterface;

class SessionGuard implements GuardInterface
{
    public function authenticate(array $credentials): bool
    {
        // Реализация сессионной аутентификации
        return false;
    }

    public function check(): bool
    {
        // Реализация проверки аутентификации
        return false;
    }

    public function user(): ?object
    {
        // Реализация получения пользователя
        return null;
    }

    public function attempt(array $credentials): bool
    {
        return $this->authenticate($credentials);
    }

    public function id(): int|string|null
    {
        $user = $this->user();
        return $user !== null && isset($user->id) ? $user->id : null;
    }

    public function logout(): void
    {
        // Реализация выхода пользователя
    }

    public function setUser(mixed $user): void
    {
        // Реализация установки пользователя
    }
}
