<?php

declare(strict_types=1);

namespace Flowaxy\Core\Events;

use Flowaxy\Domain\Events\DomainEventInterface;

// Адаптер для преобразования Domain событий в Core Events
final class DomainEventAdapter
{
    // Преобразовать Domain событие в Core Event
    public static function adapt(DomainEventInterface $domainEvent): Event
    {
        $payload = [
            'event' => get_class($domainEvent),
            'occurredAt' => $domainEvent->occurredAt()->format('Y-m-d H:i:s'),
        ];

        // Если событие имеет методы для получения данных, добавляем их в payload
        if (method_exists($domainEvent, 'getPayload')) {
            // @phpstan-ignore-next-line - метод проверяется через method_exists
            $payload = [...$payload, ...$domainEvent->getPayload()];
        }

        return new class($payload) extends Event {
        };
    }
}
