<?php

/**
 * Контракт сервіс-провайдера для реєстрації залежностей.
 *
 * @package Flowaxy\Core\Contracts
 */

declare(strict_types=1);

namespace Flowaxy\Core\Contracts;

interface ServiceProviderInterface
{
    /**
     * Реєстрація біндів/одиночок в контейнері.
     */
    public function register(ContainerInterface $container): void;

    /**
     * Опціональна ініціалізація після реєстрації.
     */
    public function boot(ContainerInterface $container): void;
}

interface ModuleServiceProviderInterface extends ServiceProviderInterface
{
}
