<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Validation;

// Інтерфейс для валідатора
interface ValidatorInterface
{
    // Валідувати дані
    public function validate(array $data, array $rules): array;

    // Перевірити, чи валідація пройшла
    public function passes(array $data, array $rules): bool;

    // Перевірити, чи валідація не пройшла
    public function fails(array $data, array $rules): bool;

    // Отримати помилки валідації
    public function errors(array $data, array $rules): array;
}
