<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\UI;

// Інтерфейс для представлень
interface ViewInterface
{
    // Відрендерити представлення
    public function render(): string;

    // Отримати назву представлення
    public function getName(): string;

    // Отримати дані представлення
    public function getData(): array;

    // Встановити дані представлення
    public function setData(array $data): self;

    // Отримати значення за ключем
    public function get(string $key, mixed $default = null): mixed;

    // Встановити значення за ключем
    public function set(string $key, mixed $value): self;
}
