<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Service;

// Базовий інтерфейс для сервісів
interface ServiceInterface
{
    // Ініціалізація сервісу
    public function initialize(): void;

    // Отримати назву сервісу
    public function getName(): string;

    // Перевірити, чи сервіс активний
    public function isActive(): bool;

    // Активувати сервіс
    public function activate(): void;

    // Деактивувати сервіс
    public function deactivate(): void;
}
