<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Service;

// Інтерфейс для життєвого циклу сервісів
interface LifecycleInterface
{
    // Викликається при створенні сервісу
    public function onCreate(): void;

    // Викликається при ініціалізації сервісу
    public function onInitialize(): void;

    // Викликається при активації сервісу
    public function onActivate(): void;

    // Викликається при деактивації сервісу
    public function onDeactivate(): void;

    // Викликається при знищенні сервісу
    public function onDestroy(): void;
}
