<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для роботи з сесіями
interface SessionInterface
{
    // Запуск сесії
    public static function start(array $config = []): void;

    // Отримати значення з сесії
    public static function get(string $key, mixed $default = null): mixed;

    // Встановити значення в сесію
    public static function set(string $key, mixed $value): void;

    // Перевірити наявність ключа в сесії
    public static function has(string $key): bool;

    // Видалити ключ з сесії
    public static function remove(string $key): void;

    // Очистити всю сесію
    public static function clear(): void;

    // Регенерувати ID сесії
    public static function regenerate(bool $deleteOldSession = false): bool;

    // Знищити сесію
    public static function destroy(): bool;

    // Отримати ID сесії
    public static function getId(): string;

    // Перевірити, чи запущена сесія
    public static function isStarted(): bool;
}
