<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для обмеження запитів
interface RateLimiterInterface
{
    // Спробувати виконати дію з обмеженням
    public function attempt(string $key, int $maxAttempts, callable $callback, int $decaySeconds = 60): mixed;

    // Перевірити, чи занадто багато спроб
    public function tooManyAttempts(string $key, int $maxAttempts): bool;

    // Збільшити лічильник
    public function hit(string $key, int $decaySeconds = 60): int;

    // Отримати кількість залишкових спроб
    public function remaining(string $key, int $maxAttempts): int;

    // Скинути лічильник
    public function reset(string $key): void;

    // Отримати час до наступної спроби
    public function availableIn(string $key): int;
}
