<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для перевірки capabilities плагіна
interface PluginCapabilityInterface
{
    // Перевірити, чи має плагін capability
    public function hasCapability(string $pluginSlug, string $capability): bool;

    // Отримати всі granted capabilities для плагіна
    public function getGrantedCapabilities(string $pluginSlug): array;

    // Надати capability плагіну
    public function grantCapability(string $pluginSlug, string $capability): bool;

    // Відкликати capability у плагіна
    public function revokeCapability(string $pluginSlug, string $capability): bool;
}
