<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для хешування
interface HashInterface
{
    // Створити хеш
    public function make(string $value, array $options = []): string;

    // Перевірити хеш
    public function check(string $value, string $hash): bool;

    // Перевірити, чи потрібно перехешувати
    public function needsRehash(string $hash, array $options = []): bool;

    // Отримати інформацію про хеш
    public function info(string $hash): array;
}
