<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для охоронців аутентифікації
interface GuardInterface
{
    // Аутентифікувати користувача
    public function attempt(array $credentials): bool;

    // Перевірити, чи користувач аутентифікований
    public function check(): bool;

    // Отримати поточного користувача
    public function user(): mixed;

    // Отримати ID поточного користувача
    public function id(): int|string|null;

    // Вихід користувача
    public function logout(): void;

    // Встановити користувача
    public function setUser(mixed $user): void;
}
