<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для шифрування
interface EncryptionInterface
{
    // Зашифрувати значення
    public function encrypt(string $value): string;

    // Розшифрувати значення
    public function decrypt(string $value): string;

    // Отримати ключ шифрування
    public function getKey(): string;

    // Встановити ключ шифрування
    public function setKey(string $key): void;
}
