<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Security;

// Інтерфейс для авторизації
interface AuthorizerInterface
{
    // Перевірити, чи користувач має дозвіл
    public function can(int|string $userId, string $permission): bool;

    // Перевірити, чи користувач має роль
    public function hasRole(int|string $userId, string $role): bool;

    // Перевірити, чи користувач має будь-яку з ролей
    public function hasAnyRole(int|string $userId, array $roles): bool;

    // Перевірити, чи користувач має всі ролі
    public function hasAllRoles(int|string $userId, array $roles): bool;

    // Додати дозвіл користувачу
    public function grant(int|string $userId, string $permission): bool;

    // Забрати дозвіл у користувача
    public function revoke(int|string $userId, string $permission): bool;

    // Додати роль користувачу
    public function assignRole(int|string $userId, string $role): bool;

    // Забрати роль у користувача
    public function removeRole(int|string $userId, string $role): bool;
}
