<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Repository;

// Базовий інтерфейс для репозиторіїв
interface RepositoryInterface
{
    // Знайти запис за ID
    public function findById(int|string $id): mixed;

    // Знайти всі записи
    public function findAll(): array;

    // Знайти записи за критеріями
    public function findBy(array $criteria): array;

    // Знайти один запис за критеріями
    public function findOneBy(array $criteria): mixed;

    // Зберегти запис
    public function save(mixed $entity): mixed;

    // Видалити запис
    public function delete(mixed $entity): bool;

    // Видалити запис за ID
    public function deleteById(int|string $id): bool;

    // Перевірити існування запису
    public function exists(int|string $id): bool;

    // Підрахувати кількість записів
    public function count(array $criteria = []): int;
}
