<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Repository;

// Інтерфейс для критеріїв запитів
interface CriteriaInterface
{
    // Додати умову WHERE
    public function where(string $field, string $operator, mixed $value): self;

    // Додати умову WHERE IN
    public function whereIn(string $field, array $values): self;

    // Додати умову WHERE NOT IN
    public function whereNotIn(string $field, array $values): self;

    // Додати умову OR WHERE
    public function orWhere(string $field, string $operator, mixed $value): self;

    // Додати сортування
    public function orderBy(string $field, string $direction = 'ASC'): self;

    // Додати групування
    public function groupBy(string|array $fields): self;

    // Додати умову HAVING
    public function having(string $field, string $operator, mixed $value): self;

    // Обмежити кількість результатів
    public function limit(int $limit): self;

    // Встановити зміщення
    public function offset(int $offset): self;

    // Отримати всі критерії
    public function toArray(): array;
}
