<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Mail;

// Інтерфейс для повідомлень пошти
interface MessageInterface
{
    // Встановити отримувача
    public function to(string|array $to): self;

    // Встановити відправника
    public function from(string $from, ?string $name = null): self;

    // Встановити тему
    public function subject(string $subject): self;

    // Встановити тіло листа
    public function body(string $body, bool $isHtml = true): self;

    // Додати копію
    public function cc(string|array $cc): self;

    // Додати приховану копію
    public function bcc(string|array $bcc): self;

    // Встановити адресу для відповіді
    public function replyTo(string $replyTo): self;

    // Додати вкладення
    public function attach(string $path, ?string $name = null): self;

    // Відправити лист
    public function send(): bool;
}
