<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Mail;

// Інтерфейс для відправки пошти
interface MailerInterface
{
    // Відправити лист
    public function send(MessageInterface $message): bool;

    // Додати лист в чергу
    public function queue(MessageInterface $message): bool;

    // Створити нове повідомлення
    public function createMessage(): MessageInterface;
}
