<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Logging;

// Інтерфейс для логера
interface LoggerInterface
{
    // Логувати повідомлення
    public function log(string $message, array $context = []): void;

    // Логувати помилку
    public function error(string $message, array $context = []): void;

    // Логувати попередження
    public function warning(string $message, array $context = []): void;

    // Логувати інформацію
    public function info(string $message, array $context = []): void;

    // Логувати відлагодження
    public function debug(string $message, array $context = []): void;
}
