<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Logging;

// Інтерфейс для форматерів логів
interface LogFormatterInterface
{
    // Форматувати лог
    public function format(string $level, string $message, array $context = []): string;

    // Встановити формат дати
    public function setDateFormat(string $format): self;

    // Встановити формат повідомлення
    public function setMessageFormat(string $format): self;
}
