<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Http;

// Інтерфейс для HTTP відповідей
interface ResponseInterface
{
    // Встановити статус код
    public function status(int $code): self;

    // Встановити заголовок
    public function header(string $name, string $value): self;

    // Встановити вміст
    public function content(string $content): self;

    // Відправити відповідь
    public function send(): void;

    // Відправити JSON відповідь
    public function json(mixed $data, int $statusCode = 200): void;

    // Виконати редірект
    public function redirect(string $url, int $statusCode = 302): void;
}
