<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Http;

// Інтерфейс для HTTP запитів
interface RequestInterface
{
    // Отримати значення з запиту
    public function get(string $key, mixed $default = null): mixed;

    // Отримати всі дані запиту
    public function all(): array;

    // Отримати тільки вказані ключі
    public function only(array $keys): array;

    // Отримати всі дані крім вказаних ключів
    public function except(array $keys): array;

    // Перевірити наявність ключа
    public function has(string $key): bool;

    // Отримати метод запиту
    public function method(): string;

    // Отримати URL запиту
    public function url(): string;

    // Отримати IP адресу клієнта
    public function ip(): string;

    // Перевірити, чи це AJAX запит
    public function isAjax(): bool;

    // Перевірити, чи очікується JSON відповідь
    public function wantsJson(): bool;
}
