<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Http;

// Інтерфейс для обробки AJAX запитів
interface AjaxHandlerInterface
{
    // Реєстрація обробника дії
    public function register(string $action, callable $handler, array $options = []): self;

    // Встановлення обробника помилок
    public function setErrorHandler(callable $handler): self;

    // Встановлення обробника авторизації
    public function setAuthCallback(callable $handler): self;

    // Перевірка чи є запит AJAX
    public static function isAjax(): bool;

    // Обробка AJAX запиту
    public function handle(?string $action = null): void;

    // Швидка реєстрація декількох дій
    public function registerMultiple(array $actions): self;

    // Отримання санітизованих даних з запиту
    public static function getSanitizedData(array $keys = []): array;

    // Отримання файлу з запиту
    public static function getFile(string $key): ?array;

    // Швидка перевірка AJAX
    public static function check(): bool;
}
