<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для завантаження файлів
interface UploadInterface
{
    // Обробити завантаження файлу
    public function handle(array $file): array|false;

    // Валідувати файл
    public function validate(array $file): bool;

    // Встановити дозволені розширення
    public function setAllowedExtensions(array $extensions): self;

    // Встановити дозволені MIME типи
    public function setAllowedMimeTypes(array $mimeTypes): self;

    // Встановити максимальний розмір файлу
    public function setMaxFileSize(int $maxSize): self;

    // Встановити директорію для завантаження
    public function setUploadDir(string $uploadDir): self;
}
