<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для роботи зі структурованими файлами
interface StructuredFileInterface extends FileInterface
{
    // Встановлення шляху до файлу
    public function setFile(string $filePath): self;

    // Завантаження даних з файлу
    public function load(): self;

    // Отримання даних з файлу
    public function getData(): mixed;

    // Встановлення даних для запису в файл
    public function setData(mixed $data): self;

    // Збереження даних в файл
    public function save(): bool;

    // Перевірка наявності завантажених даних
    public function hasData(): bool;

    // Отримання значення за ключем
    public function get(string $key, mixed $default = null): mixed;

    // Встановлення значення за ключем
    public function set(string $key, mixed $value): self;

    // Перевірка наявності ключа
    public function has(string $key): bool;

    // Видалення значення за ключем
    public function remove(string $key): self;

    // Очищення всіх даних
    public function clear(): self;
}
