<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для всіх типів сховища
interface StorageInterface
{
    // Отримання значення з сховища
    public function get(string $key, mixed $default = null): mixed;

    // Встановлення значення в сховище
    public function set(string $key, mixed $value): bool;

    // Перевірка наявності ключа в сховищі
    public function has(string $key): bool;

    // Видалення значення з сховища
    public function remove(string $key): bool;

    // Отримання всіх даних з сховища
    public function all(): array;

    // Очищення всіх даних з сховища
    public function clear(): bool;

    // Отримання кількох значень за ключами
    public function getMultiple(array $keys): array;

    // Встановлення кількох значень
    public function setMultiple(array $values): bool;

    // Видалення кількох значень
    public function removeMultiple(array $keys): bool;
}
