<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для роботи з зображеннями
interface ImageInterface
{
    // Завантажити зображення
    public function load(string $filePath): self;

    // Змінити розмір зображення
    public function resize(int $width, int $height, bool $maintainAspectRatio = true): self;

    // Обрізати зображення
    public function crop(int $x, int $y, int $width, int $height): self;

    // Повернути зображення
    public function rotate(int $angle): self;

    // Відобразити зображення дзеркально
    public function flip(string $mode = 'horizontal'): self;

    // Додати водяний знак
    public function watermark(string $watermarkPath, string $position = 'bottom-right', int $opacity = 50): self;

    // Зберегти зображення
    public function save(string $savePath, int $quality = 90): bool;

    // Вивести зображення
    public function output(int $quality = 90): void;

    // Отримати ширину
    public function getWidth(): int;

    // Отримати висоту
    public function getHeight(): int;
}
