<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для роботи з файлами
interface FileInterface
{
    // Встановлення шляху до файлу
    public function setPath(string $filePath): self;

    // Отримання шляху до файлу
    public function getPath(): string;

    // Перевірка існування файлу
    public function exists(): bool;

    // Читання вмісту файлу
    public function read(): string;

    // Запис вмісту в файл
    public function write(string $content, bool $append = false): bool;

    // Копіювання файлу
    public function copy(string $destinationPath): bool;

    // Переміщення/перейменування файлу
    public function move(string $destinationPath): bool;

    // Видалення файлу
    public function delete(): bool;

    // Отримання розміру файлу
    public function getSize(): int;

    // Отримання MIME типу файлу
    public function getMimeType(): string|false;

    // Отримання часу останньої зміни
    public function getMTime(): int|false;

    // Отримання розширення файлу
    public function getExtension(): string;

    // Отримання імені файлу з розширенням
    public function getBasename(): string;

    // Отримання імені файлу без шляху та розширення
    public function getFilename(): string;

    // Перевірка доступності файлу для читання
    public function isReadable(): bool;

    // Перевірка доступності файлу для запису
    public function isWritable(): bool;
}
